#version 330
#extension GL_EXT_gpu_shader4 : enable
//Water WaveMod01.fsh by TanayStyle
//https://www.shadertoy.com/view/Mt3yzf
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318   //0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define tau 6.28318530718

float sin01(float x) {
	return (sin(x*tau)+1.)/2.;
}
float cos01(float x) {
	return (cos(x*tau)+1.)/2.;
}

//cos between m and 1
float cosm1(float x, float m) {
    float c = 1. - m;
	float y = cos(x*tau/2.)*c+(1.-c);
    return y/2. + .5;
}

float smoothFract(float x, float blurLevel) {
	return pow(cos01(x), 1./blurLevel);
}

float euclDist(vec2 from, vec2 to) {
	return length(from - to);
}

float circ(vec2 uv, vec2 pos, float radius) {
    float dist = euclDist(uv, pos);
    return smoothstep(radius, 0., dist);
}

vec2 rot(vec2 v, float angle) {
    mat2 m;
    m[0] = vec2(cos(angle), sin(angle));
    m[1] = vec2(-sin(angle), cos(angle));
    return m * v;
}

vec3 vignette (vec2 uv, vec3 col, float amt) {
    float len = clamp(0.,1.,length(uv));
    return col * smoothstep(1., 0., len * amt);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Pixel coordinates centered at 0,0
    vec2 uv = (gl_FragCoord.xy-iResolution.xy/2.)/iResolution.xy;
    float aspectRatio = iResolution.x / iResolution.y;
	uv.x *= aspectRatio;

    float t = iTime * .2;
    
	// Distort uv coordinates
    float amplitude = .2;
    float turbulence = 1.3;
    uv.xy += sin01(uv.x*turbulence + t) * amplitude;
    uv.xy -= sin01(uv.y*turbulence + t) * amplitude;
    
    // Rotate grid as time goes by
    uv.xy = rot(uv.xy, t / 2.);
    
    //uv.xy = shear(uv.xy, t);
    
    // Create grid
    float gridSize = 4.;
    
    // Define lines
    float bright = 0.;
    float blurAmount = 0.2;
    float linesX = smoothFract(uv.y * gridSize, blurAmount);
    bright = linesX;
    
    float linesY = smoothFract(uv.x * gridSize, blurAmount);
    bright += linesY;
    
    // Convert lines to color
    vec3 linesColor = vec3(.42,.8,1.);
    vec3 col = linesColor*bright;
    
    // Background color
    vec3 backgroundColor = vec3(0.2,.6,.9);
    col += backgroundColor*(1.-bright);
    
    // Apply vignette
    col = vignette(uv, col, .4);
    
    // Output to screen
    gl_FragColor = vec4(col,1.0);
}